package w83b.w83bOperacionesPaso.w83bActas;

import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bImpugnacionesBean;
import w83b.w83bBeans.W83bListaDelegadosBean;
import w83b.w83bBeans.W83bListaSindicatosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bOperacionesPaso.w83bMantenimientos.w83bConvenios.W83bTablaConveniosExcelAction;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bActaExcelAction extends Q70ActionPasoOP{


	
	/**
	 * processOP
	 * @param contexto a
	 * @param mapping a
	 * @param errores a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	 
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/**
	 * processForward
	 * @param contexto a
	 * @param mapping a
	 * @param errors a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 * @return ActionForward
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bFichaActas.xls";//NOPMD
		InputStream inputStream = W83bTablaConveniosExcelAction.class.getResourceAsStream(strRutaExcel);//NOPMD
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro//NOPMD
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja//NOPMD
        
        
        
        W83bActasBean actasBean = (W83bActasBean)contexto.get("w83bDetalleActaTempBean");//NOPMD
        List listaSindicatos = actasBean.getListaSindicatosExcel();
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);//NOPMD

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);//NOPMD
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());      
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma, usuario);
        HSSFHeader header = sheet.getHeader();//NOPMD
        header.setRight(W83bDateUtil.getInstance().getLocaleStringFromDate(new Date(), idioma));
        
        HSSFFooter footer = sheet.getFooter();//NOPMD

        footer.setCenter(((W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada());
        footer.setRight(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.label.pag",idioma,new String[]{footer.page()}));//NOPMD

        
        
        HSSFRow row ; 
        HSSFCell cell;
        ////
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)3);
        StringBuffer tituloImagenEs = new StringBuffer();
        StringBuffer tituloImagenEu = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)6); 
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)3);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)6); 
        cell.setCellValue(tituloImagenEs.toString());
        
        
        
        row = sheet.getRow(Short.parseShort("9")); 
        cell = row.getCell(Short.parseShort("1")); 
        HSSFCell cell2 = row.createCell(Short.parseShort("2"));
        HSSFCell cell3 = row.createCell(Short.parseShort("3"));
        HSSFCell cell4 = row.createCell(Short.parseShort("4"));
        HSSFCell cell5 = row.createCell(Short.parseShort("5"));
        HSSFCell cell6 = row.createCell(Short.parseShort("6"));
        HSSFCell cell7 = row.createCell(Short.parseShort("7"));
        HSSFCell cell8 = row.createCell(Short.parseShort("8"));
        sheet.addMergedRegion(new Region(9,Short.parseShort("1"),9,Short.parseShort("8")));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fichaActa",idioma));
        cell2.setCellStyle(estiloNegritaSubrayadoCentrado(9,excel));
        cell3.setCellStyle(estiloNegritaSubrayadoCentrado(9,excel));
        cell4.setCellStyle(estiloNegritaSubrayadoCentrado(9,excel));
        cell5.setCellStyle(estiloNegritaSubrayadoCentrado(9,excel));
        cell6.setCellStyle(estiloNegritaSubrayadoCentrado(9,excel));
        cell7.setCellStyle(estiloNegritaSubrayadoCentrado(9,excel));
        cell8.setCellStyle(estiloNegritaSubrayadoCentrado(9,excel));
        //MAPEO FORMULARIO
        //NUMERO ACTA
        row = sheet.getRow(Short.parseShort("11")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)11,(short)1,(short)11,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.datosActa",idioma));
        cell.setCellStyle(estiloNegritaSubrayadoTabla(11,excel));
        cell2.setCellStyle(estiloNegritaSubrayadoTabla(11,excel));
        
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)12,(short)1,(short)12,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.numeroActa",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)12,(short)3,(short)12,(short)7)); //NOPMD
        String num=actasBean.getNumActa();
        if(StringUtils.isEmpty(actasBean.getNumActa())){
			num = "000000";
		}else if(6>actasBean.getNumActa().length()){
			for(int i = actasBean.getNumActa().length(),size = 6;i<size;i++){
				num = "0"+num;//NOPMD
			}
		}
        String acta=actasBean.getNumActaTerritorio() + "/" +actasBean.getNumActaAno() + "/" +num;
        cell.setCellValue(acta);
        //fin NUMERO ACTA
        
        //NUMERO ACTA TOTAL
        row = sheet.getRow(Short.parseShort("13")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)13,(short)1,(short)13,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.numeroActaTotal",idioma));
        String total="";
        if(StringUtils.isNotEmpty(actasBean.getAnyoActaTotal())&&StringUtils.isNotEmpty(actasBean.getNumActaTotal())){
        	num=actasBean.getNumActaTotal();
            if(StringUtils.isEmpty(actasBean.getNumActaTotal())){
    			num = "000000";
    		}else if(6>actasBean.getNumActaTotal().length()){
    			for(int i = actasBean.getNumActaTotal().length(),size = 6;i<size;i++){
    				num = "0"+num;//NOPMD
    			}
    		}
        	total=actasBean.getNumActaTerritorio() + "/" +actasBean.getAnyoActaTotal()+ "/" +num;
        }
        cell = row.createCell(Short.parseShort("3"));    
        sheet.addMergedRegion(new Region((short)13,(short)3,(short)13,(short)7)); //NOPMD
        cell.setCellValue(total);
        //FIN NUMERO ACTA TOTAL
        
        //NUMERO PREAVISO
        row = sheet.getRow(Short.parseShort("14")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)14,(short)1,(short)14,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.numeroPreaviso",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)14,(short)3,(short)14,(short)7)); //NOPMD
        String preaviso="";
        if(StringUtils.isNotEmpty(actasBean.getAnyoPreaviso())&&StringUtils.isNotEmpty(actasBean.getNumPreaviso())){
        	num=actasBean.getNumPreaviso();
            if(StringUtils.isEmpty(actasBean.getNumPreaviso())){
    			num = "000000";
    		}else if(6>actasBean.getNumPreaviso().length()){
    			for(int i = actasBean.getNumPreaviso().length(),size = 6;i<size;i++){
    				num = "0"+num;//NOPMD
    			}
    		}
        	preaviso=actasBean.getTerritorioPreaviso() + "/" +actasBean.getAnyoPreaviso()+ "/" +num;
        }
        cell.setCellValue(preaviso);        
        //fin NUMERO REGISTRO DEFINITIVO        
        
        //CONVENIO        
        row = sheet.getRow(Short.parseShort("15")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)15,(short)1,(short)15,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.convenio",idioma));
        cell = row.getCell(Short.parseShort("3"));
        sheet.addMergedRegion(new Region((short)15,(short)3,(short)15,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getConvenioTxt())){
        	cell.setCellValue(actasBean.getConvenioTxt());
        }
        //fin CONVENIO        
        
        //N de Registro E/S       
        row = sheet.getRow(Short.parseShort("16")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)16,(short)1,(short)16,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.numeroRegistroES",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)16,(short)3,(short)16,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getNumRegistroES())){
        	cell.setCellValue(actasBean.getNumRegistroES().toUpperCase());
        }
        //fin N de Registro  E/S 
        
        //Fecha de Registro E/S       
        row = sheet.getRow(Short.parseShort("17")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)17,(short)1,(short)17,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fechaRegistroES",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)17,(short)3,(short)17,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getFechaRegistroES())){
        	cell.setCellValue(actasBean.getFechaRegistroES());
        }
        //fin Fecha de Registro E/S
        
        //N de Registro DEFINITIVO       
        row = sheet.getRow(Short.parseShort("18")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)18,(short)1,(short)18,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nRegDefinitivo",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)18,(short)3,(short)18,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getNumRegDefinitivo())){
        	cell.setCellValue(actasBean.getNumRegDefinitivo().toUpperCase());
        }
        //fin N de Registro  DEFINITIVO
        
        //Fecha de Registro DEFINITIVO       
        row = sheet.getRow(Short.parseShort("19")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)19,(short)1,(short)19,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fRegDefinitivo",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)19,(short)3,(short)19,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getFechaRegistroDefinitivo())){
        	cell.setCellValue(actasBean.getFechaRegistroDefinitivo());
        }
        //fin Fecha de Registro  DEFINITIVO
        
        //Fecha ELECCION      
        row = sheet.getRow(Short.parseShort("20")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)20,(short)1,(short)20,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fEleccion",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)20,(short)3,(short)20,(short)7)); //NOPMD
        String fEleccion=actasBean.getFechaEleccion();
        cell.setCellValue(fEleccion);        
        //fin Fecha ELECCION
        
        //Fecha ENTRADA
        row = sheet.getRow(Short.parseShort("21")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)21,(short)1,(short)21,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fEntrada",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)21,(short)3,(short)21,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getFechaEntrada())){
        	cell.setCellValue(actasBean.getFechaEntrada());
        }
        //fin Fecha ELECCION
        
        //Fecha COMISION
        row = sheet.getRow(Short.parseShort("22")); 
        cell = row.getCell(Short.parseShort("1")); 
        sheet.addMergedRegion(new Region((short)22,(short)1,(short)22,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fComision",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)22,(short)3,(short)22,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getFechaComision())){
        	cell.setCellValue(actasBean.getFechaComision());
        }
        //fin Fecha COMISION
        
        //Fecha BAJA
        row = sheet.getRow(Short.parseShort("23")); 
        cell = row.getCell(Short.parseShort("1")); 
        sheet.addMergedRegion(new Region((short)23,(short)1,(short)23,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fBaja",idioma));
        cell = row.createCell(Short.parseShort("3"));
        sheet.addMergedRegion(new Region((short)23,(short)3,(short)23,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getFechaBaja())){
        	cell.setCellValue(actasBean.getFechaBaja());
        }
        //fin Fecha BAJA
        
        //MOTIVO BAJA
        row = sheet.getRow(Short.parseShort("24")); 
        cell = row.getCell(Short.parseShort("1")); 
        sheet.addMergedRegion(new Region((short)24,(short)1,(short)24,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.motivoBaja",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)24,(short)3,(short)24,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getMotivoBajaTxt())){
        	cell.setCellValue(actasBean.getMotivoBajaTxt());
        }
        //fin MOTIVO BAJA
        
        //OBSERVACIONES
        row = sheet.getRow(Short.parseShort("25")); 
        cell = row.getCell(Short.parseShort("1")); 
        sheet.addMergedRegion(new Region((short)25,(short)1,(short)25,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.observaciones",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        cell2 = row.createCell(Short.parseShort("4")); 
        cell3 = row.createCell(Short.parseShort("5")); 
        cell4 = row.createCell(Short.parseShort("6")); 
        cell5 = row.createCell(Short.parseShort("7")); 
        sheet.addMergedRegion(new Region((short)25,(short)3,(short)25,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getObservaciones())){
        	cell.setCellValue(actasBean.getObservaciones());
        }
        cell.setCellStyle(estiloFilaBordeAbajoDerecha(25,excel));
        cell2.setCellStyle(estiloFilaBordeAbajoDerecha(25,excel));
        cell3.setCellStyle(estiloFilaBordeAbajoDerecha(25,excel));
        cell4.setCellStyle(estiloFilaBordeAbajoDerecha(25,excel));
        cell5.setCellStyle(estiloFilaBordeAbajoDerecha(25,excel));
        if(StringUtils.isNotEmpty(actasBean.getObservaciones())){
	        if(56<actasBean.getObservaciones().length()){
	        	row.setHeightInPoints((short)(22*(actasBean.getObservaciones().length()/56)+1));
	        }
        }
        //fin OBSERVACIONES
        
        //CIF
        row = sheet.getRow(Short.parseShort("27")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2"));
        sheet.addMergedRegion(new Region((short)27,(short)1,(short)27,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.datosEmpresa",idioma));
        cell.setCellStyle(estiloNegritaSubrayadoTabla(27,excel));
        cell2.setCellStyle(estiloNegritaSubrayadoTabla(27,excel));
        
        row = sheet.getRow(Short.parseShort("28")); 
        cell = row.getCell(Short.parseShort("1")); 
        sheet.addMergedRegion(new Region((short)28,(short)1,(short)28,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.cif",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)28,(short)3,(short)28,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getCifnif())){
        	cell.setCellValue(actasBean.getCentroTrabajo().getCifnif());
        }
        //fin CIF
        
        //NUM CENTRO
        row = sheet.getRow(Short.parseShort("29")); 
        cell = row.getCell(Short.parseShort("1")); 
        sheet.addMergedRegion(new Region((short)29,(short)1,(short)29,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nCentro",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)29,(short)3,(short)29,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getNumCentro())){
        	cell.setCellValue(actasBean.getCentroTrabajo().getNumCentro());
        }
        //kito lo del n xq sino a la derecha
//        cell.setCellValue(W83bUtilidades.numero(actasBean.getCentroTrabajo().getNumCentro()));        
        //fin NUM CENTRO
        
        //RAZON SOCIAL
        row = sheet.getRow(Short.parseShort("30")); 
        cell = row.getCell(Short.parseShort("1"));
        sheet.addMergedRegion(new Region((short)30,(short)1,(short)30,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.razonSocial",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)30,(short)3,(short)30,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getRazonSocial())){
        	cell.setCellValue(actasBean.getCentroTrabajo().getRazonSocial());
        }
        //FIN RAZON SOCIAL
        
        //DOMICILIO
        row = sheet.getRow(Short.parseShort("31")); 
        cell = row.getCell(Short.parseShort("1")); 
        sheet.addMergedRegion(new Region((short)31,(short)1,(short)31,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.domicilio",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)31,(short)3,(short)31,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getDomicilio())){
        	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(actasBean.getCentroTrabajo().getDomicilio()));
        }
        //FIN DOMICILIO
        
        //CODIGO POSTAL
        row = sheet.getRow(Short.parseShort("32")); 
        cell = row.getCell(Short.parseShort("1")); 
        sheet.addMergedRegion(new Region((short)32,(short)1,(short)32,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.codigoPostal",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)32,(short)3,(short)32,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getCodPostal())){
        	cell.setCellValue(actasBean.getCentroTrabajo().getCodPostal());
        }
        //kito lo del n xq sino a la derecha
//        cell.setCellValue(W83bUtilidades.numero(actasBean.getCentroTrabajo().getCodPostal()));        
        //FIN CODIGO POSTAL
        
        //LOCALIDAD
        row = sheet.getRow(Short.parseShort("33")); 
        cell = row.getCell(Short.parseShort("1")); 
        sheet.addMergedRegion(new Region((short)33,(short)1,(short)33,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.localidad",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)33,(short)3,(short)33,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getLocalidad())){
        	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(actasBean.getCentroTrabajo().getLocalidad()));
        }
        //FIN LOCALIDAD
        
        //MUNICIPIO
        row = sheet.getRow(Short.parseShort("34")); 
        cell = row.getCell(Short.parseShort("1")); 
        sheet.addMergedRegion(new Region((short)34,(short)1,(short)34,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.municipio",idioma));
        cell = row.createCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region((short)34,(short)3,(short)34,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getMunicipio())){
        	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(actasBean.getCentroTrabajo().getMunicipio()));
        }
        //FIN MUNICIPIO
        
        //PROVINCIA
        row = sheet.getRow(Short.parseShort("35")); 
        cell = row.getCell(Short.parseShort("1")); 
        sheet.addMergedRegion(new Region((short)35,(short)1,(short)35,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.provincia",idioma));
        cell = row.createCell(Short.parseShort("3"));
        cell2 = row.createCell(Short.parseShort("4")); 
        cell3 = row.createCell(Short.parseShort("5")); 
        cell4 = row.createCell(Short.parseShort("6")); 
        cell5 = row.createCell(Short.parseShort("7")); 
        sheet.addMergedRegion(new Region((short)35,(short)3,(short)35,(short)7)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getProvincia())){
        	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(actasBean.getCentroTrabajo().getProvincia()));
        }
        cell.setCellStyle(estiloFilaBordeAbajoDerecha(35,excel));
        cell2.setCellStyle(estiloFilaBordeAbajoDerecha(35,excel));
        cell3.setCellStyle(estiloFilaBordeAbajoDerecha(35,excel));
        cell4.setCellStyle(estiloFilaBordeAbajoDerecha(35,excel));
        cell5.setCellStyle(estiloFilaBordeAbajoDerecha(35,excel));
        //FIN PROVINCIA
        
        //HOMBRES, MUJERES Y TOTAL
        row = sheet.getRow(Short.parseShort("37")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.createCell(Short.parseShort("2")); 
        sheet.addMergedRegion(new Region((short)37,(short)1,(short)37,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.resultadosActa",idioma));
        cell.setCellStyle(estiloNegritaSubrayadoTabla(37,excel));
        cell2.setCellStyle(estiloNegritaSubrayadoTabla(37,excel));
        row = sheet.getRow(Short.parseShort("38")); 
        cell = row.createCell(Short.parseShort("3")); 
        cell.setCellStyle(estiloCabecera(38,excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.hombres",idioma));
        cell = row.createCell(Short.parseShort("4")); 
        cell.setCellStyle(estiloCabecera(38,excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.mujeres",idioma));
        cell = row.createCell(Short.parseShort("5"));
        cell.setCellStyle(estiloCabecera(38,excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.total",idioma));
        
        //ELECTORES
        row = sheet.getRow(Short.parseShort("39")); 
        cell = row.getCell(Short.parseShort("1"));
        cell2 = row.getCell(Short.parseShort("2")); 
        sheet.addMergedRegion(new Region((short)39,(short)1,(short)39,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.electores",idioma));
        cell = row.getCell(Short.parseShort("3")); 
        if(StringUtils.isNotEmpty(actasBean.getElectoresHombres())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getElectoresHombres()));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell(Short.parseShort("4")); 
        if(StringUtils.isNotEmpty(actasBean.getElectoresMujeres())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getElectoresMujeres()));
        }else{
        	cell.setCellValue("");
        }

        cell = row.getCell(Short.parseShort("5"));
        if(StringUtils.isNotEmpty(actasBean.getElectoresTotal())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getElectoresTotal()));
        }else{
        	cell.setCellValue("");
        }

        
        //CANDIDATOS
        row = sheet.getRow(Short.parseShort("40")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2")); 
        sheet.addMergedRegion(new Region((short)40,(short)1,(short)40,(short)2)); //NOPMD
        //cell.setCellStyle(estiloFilaBordeAbajo(33,excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.candidatos",idioma));
        cell = row.getCell(Short.parseShort("3")); 
        if(StringUtils.isNotEmpty(actasBean.getCandidatosHombres())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getCandidatosHombres()));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell(Short.parseShort("4"));
        if(StringUtils.isNotEmpty(actasBean.getCandidatosMujeres())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getCandidatosMujeres()));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell(Short.parseShort("5"));
        if(StringUtils.isNotEmpty(actasBean.getCandidatosTotal())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getCandidatosTotal()));
        }else{
        	cell.setCellValue("");
        }
        
        //ESCRUTINIO DIFERENCIAS
        row = sheet.getRow(Short.parseShort("42")); 
        cell = row.getCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region(42,Short.parseShort("3"),42,Short.parseShort("8")));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.escrutinio",idioma).toUpperCase());
        cell = row.getCell(Short.parseShort("9")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.diferencias",idioma).toUpperCase());
        
        //PAPELETAS TOTAL COLEGIO
        row = sheet.getRow(Short.parseShort("43")); 
        cell = row.getCell(Short.parseShort("3")); 
        sheet.addMergedRegion(new Region(43,Short.parseShort("3"),43,Short.parseShort("5")));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.papeletas",idioma).toUpperCase());
        cell = row.getCell(Short.parseShort("6")); 
        sheet.addMergedRegion(new Region(43,Short.parseShort("6"),43,Short.parseShort("8")));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.totalColegio",idioma).toUpperCase());
        
        //PAPELETAS TOTAL COLEGIO
        row = sheet.getRow(Short.parseShort("44")); 
        cell = row.getCell(Short.parseShort("3")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.validas",idioma).toUpperCase());
        cell = row.getCell(Short.parseShort("4")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nulas",idioma).toUpperCase());
        cell = row.getCell(Short.parseShort("5")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.blancas",idioma).toUpperCase());
        cell = row.getCell(Short.parseShort("6")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.elect",idioma).toUpperCase());
        cell = row.getCell(Short.parseShort("7")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.vot",idioma).toUpperCase());
        cell = row.getCell(Short.parseShort("8")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.deleg",idioma).toUpperCase());
        cell = row.getCell(Short.parseShort("9")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.delegadps",idioma).toUpperCase());
        
        
        //LOS DOS COLEGIOS
        row = sheet.getRow(Short.parseShort("45")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2")); 
        sheet.addMergedRegion(new Region((short)45,(short)1,(short)45,(short)2)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getColegios().getDescripcion1())){
        	cell.setCellValue(actasBean.getColegios().getDescripcion1());
        }
        cell = row.getCell(Short.parseShort("3")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getPapeletasValidasC1())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getPapeletasValidasC1()));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell(Short.parseShort("4"));
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getPapeletasNulasC1())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getPapeletasNulasC1()));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("5")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getPapeletasBlancasC1())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getPapeletasBlancasC1()));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("6")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getElectoresTotalColegioC1())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getElectoresTotalColegioC1()));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("7")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getVotantesTotalColegioC1())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getVotantesTotalColegioC1()));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("8")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getDelegadosTotalColegioC1())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getDelegadosTotalColegioC1()));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("9")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosDiferencia().getDelegadosTotalColegioC1())){
        	 cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosDiferencia().getDelegadosTotalColegioC1()));
        }else{
        	cell.setCellValue("");
        }
       
        
        row = sheet.getRow(Short.parseShort("46")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell2 = row.getCell(Short.parseShort("2")); 
        sheet.addMergedRegion(new Region((short)46,(short)1,(short)46,(short)2)); //NOPMD
        if(StringUtils.isNotEmpty(actasBean.getColegios().getDescripcion2())){
        	cell.setCellValue(actasBean.getColegios().getDescripcion2());
        }
        cell = row.getCell(Short.parseShort("3")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getPapeletasValidasC2())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getPapeletasValidasC2()));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("4"));
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getPapeletasNulasC2())){
        	 cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getPapeletasNulasC2()));
       }else{
       	cell.setCellValue("");
       }
   
        cell = row.getCell(Short.parseShort("5")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getPapeletasBlancasC2())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getPapeletasBlancasC2()));
	      }else{
	      	cell.setCellValue("");
	      }
        
        cell = row.getCell(Short.parseShort("6")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getElectoresTotalColegioC2())){
        	 cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getElectoresTotalColegioC2()));
	    }else{
	      	cell.setCellValue("");
	    }
       
        cell = row.getCell(Short.parseShort("7")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getVotantesTotalColegioC2())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getVotantesTotalColegioC2()));
	    }else{
	      	cell.setCellValue("");
	    }
        
        cell = row.getCell(Short.parseShort("8")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosEscrutinio().getDelegadosTotalColegioC2())){
        	 cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosEscrutinio().getDelegadosTotalColegioC2()));
	    }else{
	      	cell.setCellValue("");
	    }
       
        cell = row.getCell(Short.parseShort("9")); 
        if(StringUtils.isNotEmpty(actasBean.getDatosDiferencia().getDelegadosTotalColegioC2())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getDatosDiferencia().getDelegadosTotalColegioC2()));
	    }else{
	      	cell.setCellValue("");
	    }
        
        
      //LOS DELEGADOS
        row = sheet.getRow(Short.parseShort("48")); 
        cell = row.getCell(Short.parseShort("1"));
        cell2 = row.getCell(Short.parseShort("2")); 
        sheet.addMergedRegion(new Region((short)48,(short)1,(short)48,(short)2)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.totalDelegados",idioma));
        cell = row.getCell(Short.parseShort("3")); 
        String delegadosTot = actasBean.getDelegadosTotal();
        if(StringUtils.isEmpty(delegadosTot)){
        	delegadosTot = "0";
        }
        cell.setCellValue(W83bUtilidades.numero(delegadosTot));//falta

        cell = row.getCell(Short.parseShort("5")); 
        sheet.addMergedRegion(new Region(48,Short.parseShort("5"),48,Short.parseShort("6")));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.maximoDelegados",idioma));
        cell = row.getCell(Short.parseShort("7"));
        if(StringUtils.isNotEmpty(actasBean.getDelegadosMaximo())){
        	cell.setCellValue(W83bUtilidades.numero(actasBean.getDelegadosMaximo()));
        }else{
        	cell.setCellValue("");
        }

        
        //LOS SINDICATOS
        row = sheet.getRow(Short.parseShort("50")); 
        cell = row.getCell(Short.parseShort("3")); 
        cell2 = row.createCell(Short.parseShort("4")); 
    	cell3 = row.createCell(Short.parseShort("5")); 
    	cell4 = row.createCell(Short.parseShort("6")); 
        sheet.addMergedRegion(new Region(50,Short.parseShort("3"),50,Short.parseShort("6")));
        cell.setCellStyle(estiloCabecera(50,excel));
        cell2.setCellStyle(estiloCabecera(50,excel));
    	cell3.setCellStyle(estiloCabecera(50,excel));
    	cell4.setCellStyle(estiloCabecera(50,excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.sindicato",idioma).toUpperCase());
        
        cell = row.getCell(Short.parseShort("7")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.hombres",idioma).toUpperCase());
        cell.setCellStyle(estiloCabecera(50,excel));
        cell = row.getCell(Short.parseShort("8")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.mujeres",idioma).toUpperCase());
        cell.setCellStyle(estiloCabecera(50,excel));
        cell = row.getCell(Short.parseShort("9")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nVotos",idioma).toUpperCase());
        cell.setCellStyle(estiloCabecera(50,excel));
        int i=0;
       if(null!=listaSindicatos){
	        for(i=0;i<listaSindicatos.size();i++){
	        	row = sheet.createRow((short)51+i); // Creacin de la fila 1
	        	
	        	//COLEGIO
	        	cell = row.createCell(Short.parseShort("1")); 
	        	cell2 = row.createCell(Short.parseShort("2")); 
	            sheet.addMergedRegion(new Region((short)51+i,(short)1,(short)51+i,(short)2)); //NOPMD
	            if(StringUtils.isNotEmpty(((W83bListaSindicatosBean)listaSindicatos.get(i)).getDescripcionColegio())){
	            	cell.setCellValue(((W83bListaSindicatosBean)listaSindicatos.get(i)).getDescripcionColegio());
	            }
	        	cell.setCellStyle(estiloFila(51+i,excel));
	        	cell2.setCellStyle(estiloFila(51+i,excel));
	        	
	        	//SINDICATO
	        	cell = row.createCell(Short.parseShort("3"));
	        	cell2 = row.createCell(Short.parseShort("4")); 
	        	cell3 = row.createCell(Short.parseShort("5")); 
	        	cell4 = row.createCell(Short.parseShort("6")); 
	        	sheet.addMergedRegion(new Region(51+i,Short.parseShort("3"),51+i,Short.parseShort("6")));//NOPMD
	        	if(StringUtils.isNotEmpty(((W83bListaSindicatosBean)listaSindicatos.get(i)).getDescripcionSindicato())){
	        		cell.setCellValue(((W83bListaSindicatosBean)listaSindicatos.get(i)).getDescripcionSindicato());
	        	}
	        	cell.setCellStyle(estiloFila(51+i,excel));
	        	cell2.setCellStyle(estiloFila(51+i,excel));
	        	cell3.setCellStyle(estiloFila(51+i,excel));
	        	cell4.setCellStyle(estiloFila(51+i,excel));
	        	
	        	//HOMBRES
	        	cell = row.createCell(Short.parseShort("7")); 
	        	if(StringUtils.isNotEmpty(((W83bListaSindicatosBean)listaSindicatos.get(i)).getDelegadosHombres())){
	        		cell.setCellValue(W83bUtilidades.numero(((W83bListaSindicatosBean)listaSindicatos.get(i)).getDelegadosHombres()));
	    	    }else{
	    	      	cell.setCellValue("");
	    	    }
	        	
	        	cell.setCellStyle(estiloFilaNumeroCentrado(51+i,excel));
	        	
	        	//MUJERES
	        	cell = row.createCell(Short.parseShort("8")); 
	        	if(StringUtils.isNotEmpty(((W83bListaSindicatosBean)listaSindicatos.get(i)).getDelegadosMujeres())){
	        		cell.setCellValue(W83bUtilidades.numero(((W83bListaSindicatosBean)listaSindicatos.get(i)).getDelegadosMujeres()));
	    	    }else{
	    	      	cell.setCellValue("");
	    	    }
	        	
	        	cell.setCellStyle(estiloFilaNumeroCentrado(51+i,excel));
	        	
	        	//VOTOS
	        	cell = row.createCell(Short.parseShort("9")); 
	        	if(StringUtils.isNotEmpty(((W83bListaSindicatosBean)listaSindicatos.get(i)).getVotos())){
	        		cell.setCellValue(W83bUtilidades.numero(((W83bListaSindicatosBean)listaSindicatos.get(i)).getVotos()));
	    	    }else{
	    	      	cell.setCellValue("");
	    	    }
	        	
	        	cell.setCellStyle(estiloFilaNumeroCentrado(51+i,excel));
	        	
	        	//celda vacia
	        	cell = row.createCell(Short.parseShort("10")); 
	        	cell.setCellStyle(estiloBordeDerecha(51+i,excel));
	        	
	        }
	      
        }
       i = i+1;
       row = sheet.createRow((short)51+i);
       cell = row.createCell(Short.parseShort("10")); 
   	   cell.setCellStyle(estiloBordeDerecha(51+i,excel));
   	   
       i = i+1;
       row = sheet.createRow((short)51+i);
       HashMap listaDelegados = actasBean.getListaDelegados();
       TreeMap listaDelegadosOrden = new TreeMap(listaDelegados);
       Collection listaDel= listaDelegadosOrden.values();
       Iterator ite = listaDel.iterator();
       cell = row.createCell(Short.parseShort("1"));
       cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.colegio",idioma).toUpperCase());
       cell.setCellStyle(estiloCabecera(51+i,excel));
       cell = row.createCell(Short.parseShort("2"));
       sheet.addMergedRegion(new Region(51+i,Short.parseShort("2"),51+i,Short.parseShort("3")));
       cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.sindicato",idioma).toUpperCase());
       cell.setCellStyle(estiloCabecera(51+i,excel));
       cell = row.createCell(Short.parseShort("3"));
       cell.setCellStyle(estiloCabecera(51+i,excel));
       cell = row.createCell(Short.parseShort("4"));
       cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nombre",idioma).toUpperCase());
       cell.setCellStyle(estiloCabecera(51+i,excel));
       cell = row.createCell(Short.parseShort("5"));
       cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.sexo",idioma).toUpperCase());
       cell.setCellStyle(estiloCabecera(51+i,excel));
       cell = row.createCell(Short.parseShort("6"));
       cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.DNI",idioma).toUpperCase());
       cell.setCellStyle(estiloCabecera(51+i,excel));
       cell = row.createCell(Short.parseShort("7"));
       cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fAlta",idioma).toUpperCase()+" - "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fBaja",idioma).toUpperCase());
       cell.setCellStyle(estiloCabecera(51+i,excel));
       cell = row.createCell(Short.parseShort("8"));
       cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.dniSustituto",idioma).toUpperCase());
       cell.setCellStyle(estiloCabecera(51+i,excel));
       cell = row.createCell(Short.parseShort("9"));
       cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.motivoBaja",idioma).toUpperCase());
       cell.setCellStyle(estiloCabecera(51+i,excel));
       cell = row.createCell(Short.parseShort("10")); 
   	   cell.setCellStyle(estiloBordeDerecha(51+i,excel));
       
       if(null!=ite){
    	   while (ite.hasNext()){
    		    i = i+1;
	        	row = sheet.createRow((short)51+i);
	        	W83bListaDelegadosBean delCurrent = (W83bListaDelegadosBean) ite.next();
	        	cell = row.createCell(Short.parseShort("1"));
	        	if(StringUtils.isNotEmpty(delCurrent.getColegioDesc())){
	        		cell.setCellValue(delCurrent.getColegioDesc());
	        	}else{
	        		cell.setCellValue("");
	        	}
	        	cell.setCellStyle(estiloFila(51+i,excel));
	        	cell = row.createCell(Short.parseShort("2"));
	        	sheet.addMergedRegion(new Region(51+i,Short.parseShort("2"),51+i,Short.parseShort("3")));//NOPMD
	        	if(StringUtils.isNotEmpty(delCurrent.getSindicato())){
	        		cell.setCellValue(delCurrent.getSindicato());
	        	}else{
	        		cell.setCellValue("");
	        	}
	        	cell.setCellStyle(estiloFila(51+i,excel));
	        	cell = row.createCell(Short.parseShort("3"));
	        	cell.setCellStyle(estiloFila(51+i,excel));
	        	cell = row.createCell(Short.parseShort("4"));
	        	StringBuffer pNombre = new StringBuffer();//NOPMD
	        	pNombre.append(delCurrent.getNombre()).append(" ").append(delCurrent.getApellido1()).append(" ").append(delCurrent.getApellido2());
	        	if(StringUtils.isNotEmpty(pNombre.toString())){
	        		cell.setCellValue(pNombre.toString());
	        	}else{
	        		cell.setCellValue("");
	        	}
	        	cell.setCellStyle(estiloFila(51+i,excel));
	        	cell = row.createCell(Short.parseShort("5"));
	        	if(StringUtils.isNotEmpty(delCurrent.getSexo())){
	        		cell.setCellValue(delCurrent.getSexo());
	        	}else{
	        		cell.setCellValue("");
	        	}
	        	cell.setCellStyle(estiloFilaNumeroCentrado(51+i,excel));
	        	cell = row.createCell(Short.parseShort("6"));
	        	if(StringUtils.isNotEmpty(delCurrent.getDni())){
	        		cell.setCellValue(delCurrent.getDni());
	        	}else{
	        		cell.setCellValue("");
	        	}
	        	cell.setCellStyle(estiloFilaNumeroCentrado(51+i,excel));
	        	cell = row.createCell(Short.parseShort("7"));
	        	StringBuffer pFechas = new StringBuffer();//NOPMD
	        	if(StringUtils.isNotEmpty(delCurrent.getFechaAlta())){
	        		pFechas.append(delCurrent.getFechaAlta()).append("-");
	        	}else{
	        		pFechas.append("/").append("-");
	        	}
	        	if(StringUtils.isNotEmpty(delCurrent.getFechaBaja())){
	        		pFechas.append(delCurrent.getFechaBaja());
	        	}else{
	        		pFechas.append("/");
	        	}
	        	cell.setCellValue(pFechas.toString());
	        	cell.setCellStyle(estiloFila(51+i,excel));
	        	cell = row.createCell(Short.parseShort("8"));
	        	if(StringUtils.isNotEmpty(delCurrent.getDniSustituto())){
	        		cell.setCellValue(delCurrent.getDniSustituto());
	        	}else{
	        		cell.setCellValue("");
	        	}
	        	cell.setCellStyle(estiloFilaNumeroCentrado(51+i,excel));
	        	cell = row.createCell(Short.parseShort("9"));
	        	if(StringUtils.isNotEmpty(delCurrent.getMotivoBaja())){
	        		cell.setCellValue(delCurrent.getMotivoBaja());
	        	}else{
	        		cell.setCellValue("");
	        	}
	        	cell.setCellStyle(estiloFilaNumeroCentrado(51+i,excel));
	        	cell = row.createCell(Short.parseShort("10")); 
	        	cell.setCellStyle(estiloBordeDerecha(51+i,excel));
	        }
	    
       }
       		
     //celda vacia
  		cell = row.createCell(Short.parseShort("10")); 
  		cell.setCellStyle(estiloFilaBordeAbajoDerecha(51+i,excel));
  		
  		
  	//Impugnaciones
  		 i = 51+i+2;
  		 int tamanyoTexto = 0;
        List datosImpugnaciones =actasBean.getListaImpugnaciones();
        HSSFRow rowTemp; 
        String valor = "";
        if(null!=datosImpugnaciones
        		&&datosImpugnaciones.size()>0){
        	int filaStyle = 11 ;
	        rowTemp = sheet.getRow((short)filaStyle++);
	        row = sheet.createRow((short)++i); 
	        cell = row.createCell((short)1);
	        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.impugnaciones",idioma));
	        cell = row.createCell((short)2);
	        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
	        cell = row.createCell((short)3);
	        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
	        cell = row.createCell((short)4);
	        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
	        cell = row.createCell((short)5);
	        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
	        cell = row.createCell((short)6);
	        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
	        cell = row.createCell((short)7);
	        cell.setCellStyle(rowTemp.getCell((short)7).getCellStyle());
	        
	        rowTemp = sheet.getRow((short)filaStyle++);
	        row = sheet.createRow((short)++i); 
	        cell = row.createCell((short)1);
	        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
	        cell = row.createCell((short)7);
	        cell.setCellStyle(rowTemp.getCell((short)7).getCellStyle());
	//        String [] datosImpugnacion=null;
	        rowTemp = sheet.getRow((short)filaStyle++);
	        for (int j=0;j<datosImpugnaciones.size();j++)
	        {
	//        	if (StringUtils.isNotEmpty(datosImpugnaciones[i])){	
	        	W83bImpugnacionesBean impugnacion = (W83bImpugnacionesBean)datosImpugnaciones.get(j);
	        	 i = i+1;
	        		row = sheet.createRow((short)i); 
	                cell = row.createCell((short)1);
	//	           	datosImpugnacion=datosImpugnaciones[i].split("_");
	                sheet.addMergedRegion(new Region((short)i,(short)1,(short)i,(short)3));//NOPMD
	                
		           	if (StringUtils.isNotEmpty(impugnacion.getNum_impugnacion()))
		           	{
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nImpugnacion",idioma)
		           				+":  "+impugnacion.getNum_impugnacion());
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nImpugnacion",idioma)
		                   		+":  ");
		           	}
//		           	sheet.addMergedRegion(new Region((short)i,(short)3,(short)i,(short)7)); //NOPMD
		           	cell.setCellStyle(estiloNegritaBordeIzq(0,excel));
//	               row = sheet.createRow((short)i); 
	               cell = row.createCell((short)5); 
	           	if (StringUtils.isNotEmpty(impugnacion.getFecha_impugnacion()))
		           	{
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fImpugnacion",idioma)
		           				+":  "+impugnacion.getFecha_impugnacion());
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fImpugnacion",idioma)
		                   		+":  ");
		           	}
//	               cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
//	               cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
	           		cell.setCellStyle(estiloNegrita(0,excel));
//	           		cell = row.createCell((short)5); 
	           		cell = row.createCell((short)7); 
	           		cell.setCellStyle(rowTemp.getCell((short)7).getCellStyle());
	           	i++;
	               row = sheet.createRow((short)i); 
	               cell = row.createCell((short)1); 
	               sheet.addMergedRegion(new Region(i,Short.parseShort("1"),i,Short.parseShort("3")));//NOPMD
	               cell.setCellStyle(estiloNegritaBordeIzq(0,excel));
	           	if (StringUtils.isNotEmpty(impugnacion.getTipo()))
		           	{
	            	   valor = W83bUtilidadesExcel.mayusculasCampoExcel(impugnacion.getTipo());
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.tipo",idioma)
		           				+":  "+impugnacion.getTipo());
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.tipo",idioma)
		                   		+":  ");
		           	}
	           	cell = row.createCell((short)7); 
           		cell.setCellStyle(rowTemp.getCell((short)7).getCellStyle());
	           		i++;
	           		row = sheet.createRow((short)i); 
		               cell = row.createCell((short)1); 
		               sheet.addMergedRegion(new Region(i,Short.parseShort("1"),i,Short.parseShort("6")));//NOPMD
		               cell.setCellStyle(estiloNegritaBordeIzq(0,excel));
	           	if (StringUtils.isNotEmpty(impugnacion.getNombre_arbitro()))
		           	{
	            	   valor = W83bUtilidadesExcel.mayusculasCampoExcel(impugnacion.getNombre_arbitro());
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.arbitros.nombreArbitro",idioma)
		           				+":  "+valor);
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.arbitros.nombreArbitro",idioma)
		                   		+":  ");
		           	}
	            	tamanyoTexto = cell.getStringCellValue().length();
	               if(93<tamanyoTexto){
	               	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
	               }
	               cell = row.createCell((short)7); 
	           		cell.setCellStyle(rowTemp.getCell((short)7).getCellStyle());
	               i++;
		               row = sheet.createRow((short)i); 
		               cell = row.createCell((short)1); 
		               cell.setCellStyle(estiloNegritaBordeIzq(0,excel));
	           	if (StringUtils.isNotEmpty(impugnacion.getFech_laudo()))
		           	{
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaLaudo",idioma)
		           				+":  "+impugnacion.getFech_laudo());
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaLaudo",idioma)
		                   		+":  ");
		           	}
//	               row = sheet.createRow((short)i); 
	               cell = row.createCell((short)5); 
	               cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
	           	if (StringUtils.isNotEmpty(impugnacion.getResultadoDesc()))
		           	{valor = W83bUtilidadesExcel.mayusculasCampoExcel(impugnacion.getResultado());
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.resultado",idioma)
		           				+":  "+impugnacion.getResultadoDesc());
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.resultado",idioma)
		                   		+":  ");
		           	}
	               cell = row.createCell((short)7); 
	               cell.setCellStyle(rowTemp.getCell((short)7).getCellStyle());
	//        	}
	            if(j==datosImpugnaciones.size()-1){	            	
	            	cell = row.getCell((short)1); 
	            	cell.setCellStyle(estiloNegritaBordeAbajoIzq(0,excel));
	            	cell = row.createCell((short)2); 
	            	cell.setCellStyle(styleBordeAbajo(0,excel));
	            	cell = row.createCell((short)3); 
	            	cell.setCellStyle(styleBordeAbajo(0,excel));
	            	cell = row.createCell((short)4); 
	            	cell.setCellStyle(styleBordeAbajo(0,excel));
	            	cell = row.getCell((short)5); 
	            	if(null!=cell){
	            		cell.setCellStyle(styleBordeAbajo(0,excel));
	            	}else{
	            		cell = row.createCell((short)5); 
	            		cell.setCellStyle(styleBordeAbajo(0,excel));	            		
	            	}
	            	cell = row.createCell((short)6); 
	            	cell.setCellStyle(styleBordeAbajo(0,excel));
	            	cell = row.createCell((short)7); 
	            	cell.setCellStyle(sheet.getRow(35).getCell((short)7).getCellStyle());
	            }else{
	            	i++;
	            	row = sheet.createRow(i);
	            	cell = row.createCell((short)1); 
	            	cell.setCellStyle(estiloNegritaBordeIzq(0,excel));
	            	cell = row.createCell((short)7); 
	            	cell.setCellStyle(rowTemp.getCell((short)7).getCellStyle());
	            }
	        	
	        }
        }
  		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=Acta.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}		
	}
	
	
	
	/**
	 * Estilo fila numero.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
		
	/**
	 * Estilo fila borde.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaBordeAbajoDerecha(int nFila, W83bUtilidadesExcel excel){
		return excel.styleBordeAbajoDcha;
		
		
	}
	/**
	 * Estilo cabecera.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloCabecera(int nFila, W83bUtilidadesExcel excel){
		return excel.styleCabecera;
		
		
	}
	/**
	 * Estilo negrita subrayado tabla.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloNegritaSubrayadoTabla(int nFila, W83bUtilidadesExcel excel){
		return excel.styleNegritaSubTabla;
		
		
	}
	/**
	 * Estilo negrita subrayado centrado.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloNegritaSubrayadoCentrado(int nFila, W83bUtilidadesExcel excel){
		return excel.styleNegritaSubCentrado;
		
		
	}
	/**
	 * Estilo negrita subrayado centrado.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloNegritaBordeIzq(int nFila, W83bUtilidadesExcel excel){
		return excel.styleNegritaBordeIzq;		
	}
	/**
	 * Estilo negrita subrayado centrado.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloNegritaBordeAbajoIzq(int nFila, W83bUtilidadesExcel excel){
		return excel.styleNegritaBordeAbajoIzq;		
	}
	/**
	 * Estilo negrita subrayado centrado.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle styleBordeAbajo(int nFila, W83bUtilidadesExcel excel){
		return excel.styleBordeAbajo;		
	}
	/**
	 * Estilo negrita subrayado centrado.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloNegrita(int nFila, W83bUtilidadesExcel excel){
		return excel.styleNegrita;
		
		
	}
	
	/**
	 * Estilo borde derecha.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloBordeDerecha(int nFila, W83bUtilidadesExcel excel){
		return excel.styleBordeDcha;
		
		
	}
	
	
}
